//
//  AHKABMainWindowController_Pasteboard.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Tue Ma 7 2006.
//  Copyright (c) 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABMainWindowController.h"
#import "AHKABArrayController.h"
#import "AHKPerson.h"

NSString	*AHKABRowIndexesPboardType	= @"AHKABRowIndexesPboardType"; // for moving in drag and drop (Do not use in copy and paste.)
NSString	*AHKABPeoplePboardType		= @"AHKABPeoplePboardType"; // for copying
//NSString	*ABPeopleDictPboardType		= @"ABPeopleDictPboardType"; // one of pasteboard type in Address Book, currently not used in this program.

@implementation AHKABMainWindowController (Pasteboard)

#pragma mark public methods

// -- The method -tableView:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes: in NSTableDataSource imformal protocol is available only Mac OS X 10.4 and later, thus we do not provide drop HFS promised file as a dragging source on Panther (Mac OS X 10.3.x) . --
- (NSArray *)distributablePasteboardTypes
{
	NSArray *array = [NSArray arrayWithObjects:AHKABRowIndexesPboardType, AHKABPeoplePboardType, NSVCardPboardType, NSFilenamesPboardType, NSStringPboardType, nil]; //
	
	if (floor(NSAppKitVersionNumber) <= NSAppKitVersionNumber10_3) { // On a 10.3 - 10.3.x system
		return array;
	} else { // On a 10.4 or later system
		return [array arrayByAddingObject:NSFilesPromisePboardType];
	}
}

- (NSArray *)acceptablePasteboardTypes
{
	return [NSArray arrayWithObjects:AHKABPeoplePboardType, NSVCardPboardType, NSFilenamesPboardType, nil];
}

- (BOOL)writePeopleAtIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard types:(NSArray *)types
{
	NSMutableArray	*typesToDeclare		= [NSMutableArray array];
	NSArray			*distributableTypes	= [self distributablePasteboardTypes];
	NSEnumerator	*enumerator			= [distributableTypes objectEnumerator];
	NSString		*type;
	
	while ((type = [enumerator nextObject])) {
		if ([types containsObject:type]) [typesToDeclare addObject:type];
	}
	
	BOOL			result				= NO;
//	NSArray			*people				= [[peopleController arrangedObjects] objectsAtIndexes:rowIndexes]; // objectsAtIndexes: of NSArray is available in Mac OS X version 10.4 and later.
	NSMutableArray	*people				= [NSMutableArray arrayWithCapacity:[rowIndexes count]];
	unsigned int	index				= [rowIndexes firstIndex];
	
	while (index != NSNotFound) {
		[people addObject:[[peopleController arrangedObjects] objectAtIndex:index]];
		index = [rowIndexes indexGreaterThanIndex:index];
	}
	
	if ([typesToDeclare count] > 0) {
        [pboard declareTypes:typesToDeclare owner:self];
		enumerator = [typesToDeclare objectEnumerator];
		while (type = [enumerator nextObject]) {
			
			// -- add archived NSIndexes data of selected rows on pasteboard -- 
			// -- This paste board type is only for drag and drop. Be careful not to use this in pasting process (gneral paste board). Items indicated by rows can be changed owning to delete, arrangement, sort, or filtering; it causes unexpected data being pasted. --
			if ([type isEqualToString:AHKABRowIndexesPboardType]) {
				// [pboard setPropertyList:rows forType:AHKABRowIndexesPboardType];
				NSData	*data = [NSKeyedArchiver archivedDataWithRootObject:rowIndexes];
				if (data && [data length] > 0) {
					if ([pboard setData:data forType:AHKABRowIndexesPboardType]) {
						result = YES;
					}
				}
			
			// -- add archived NSArray data which consists of currelntly selected AHKPersons -- 
			} else if ([type isEqualToString:AHKABPeoplePboardType]) {
				NSData *data = [NSKeyedArchiver archivedDataWithRootObject:people];
				if (data && [data length] > 0) {
					if ([pboard setData:data forType:AHKABPeoplePboardType]) {
						result = YES;
					}
				}
			
			// -- add HFS promised files on pasteboard (Supplying only file types. Process to generate actual files is in the method of -tableView:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes: (NSTableDataSource informal protocol) in AHKABArrayController -- 
			} else if ([type isEqualToString:NSFilesPromisePboardType]) {
				if ([pboard setPropertyList:[self acceptableFileExtensions] forType:NSFilesPromisePboardType]) {
					result = YES;
				}
			}
		}
	}
	return result;
}

#pragma mark delegated methods by NSPasteboard
// method for dragging source. invoked when the data is required for a paste operation.
// This method is invoked only if the data was declared but not yet provided.
- (void)pasteboard:(NSPasteboard *)sender provideDataForType:(NSString *)type
{
	// -- In this implementation data of AHKABPeoplePboardTYpe must be provided in 
	// - (BOOL)writePeopleAtIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard types:(NSArray *)types. 
//	NSLog(@"Main window controller providing %@", type);

	NSData *archivedPeopleData = [sender dataForType:AHKABPeoplePboardType];
	if (archivedPeopleData && [archivedPeopleData length] > 0) {
		NSArray		*people		= [NSKeyedUnarchiver unarchiveObjectWithData:archivedPeopleData];
		if (people && [people isKindOfClass:[NSArray class]]) {
		
			// -- add vCard data on paste board --
			if ([type isEqualToString:NSVCardPboardType]) {
				NSData *vCardData = [AHKPerson vCardRepresentationOfPeople:people format:AHKAddressBookVCardFormat];
				if (vCardData && [vCardData length] > 0) {
					[sender setData:vCardData forType:NSVCardPboardType];
				}
			
			// -- add filenames on paste board --
			} else if ([type isEqualToString:NSFilenamesPboardType]) {
				NSFileManager	*fileManager	= [NSFileManager defaultManager];
				NSString		*tempDir		= [NSTemporaryDirectory() stringByAppendingPathComponent:@"AH-K3001V Utilities"];
				if ([fileManager fileExistsAtPath:tempDir] == NO) {
					[fileManager createDirectoryAtPath:tempDir attributes:nil];
				}
				
				NSMutableArray	*filenames		= [NSMutableArray arrayWithCapacity:[people count]];
				
				AHKPerson		*person;
				NSEnumerator	*enumerator		= [people objectEnumerator];
				
				while (person = [enumerator nextObject]) {
					NSString	*lastPath;
					lastPath = [NSString stringWithFormat:@"%03d_%@.vcf", 
						[person number], 
						([person name] ? [person name] : @"untitled")];
					NSString	*fullPath = [tempDir stringByAppendingPathComponent:lastPath];
					if ([[person vCardRepresentationWithFormat:AHKKyoponVCardFormat] writeToFile:fullPath
																					  atomically:YES]) {
						[filenames addObject:fullPath];
					}
				}
				[sender setPropertyList:filenames forType:NSFilenamesPboardType];
				
			// -- add string on pasteboard --
			} else if ([type isEqualToString:NSStringPboardType]) {
//				NSMutableArray	*array		= [NSMutableArray arrayWithObject:[AHKPerson tabSeparatedValuesHeader]];
				NSMutableArray	*array		= [NSMutableArray arrayWithCapacity:[people count]];
				
				AHKPerson		*person;
				NSEnumerator	*enumerator	= [people objectEnumerator];
				
				while (person = [enumerator nextObject]) {
					NSString	*string	= [person tabSeparatedValues];
					if (string) {
						[array addObject:string];
					}
				}
				[sender setString:[array componentsJoinedByString:@"\n"] forType:NSStringPboardType];
			}
		}
	}
}


#pragma mark other methods
- (BOOL)insertPeopleFromPasteboard:(NSPasteboard *)pboard atRow:(int)row
{
    NSArray			*availableTypes		= [pboard types];
	NSArray			*acceptableTypes	= [self acceptablePasteboardTypes];
    NSEnumerator	*enumerator			= [acceptableTypes objectEnumerator];
    
	NSString		*type;
	BOOL			result				= NO;
	
    while (!result && (type = [enumerator nextObject])) {
        if ([availableTypes containsObject:type]) {
			// -- unarchive NSArray which consists of AHKPerson --
			if ([type isEqualToString:AHKABPeoplePboardType]) {
				NSData *data = [pboard dataForType:AHKABPeoplePboardType];
				if (data && [data length] > 0) {
					NSArray		*people		= [NSKeyedUnarchiver unarchiveObjectWithData:data];
					if (people && [people isKindOfClass:[NSArray class]] && [people count] != 0 && [people count] + [[peopleController content] count] <= [peopleController capacity]) {
						NSRange		range		= NSMakeRange(row, [people count]);
						NSIndexSet	*indexSet	= [NSIndexSet indexSetWithIndexesInRange:range];
						[peopleController insertObjects:people atArrangedObjectIndexes:indexSet];
						result = YES;
					}
				 } 
			// -- load people from vCard data (NSVCardPboardType) --
			} else if ([type isEqualToString:NSVCardPboardType]) {
				NSData		*vCardData	= [pboard dataForType:NSVCardPboardType];
				NSArray		*people		= [AHKPerson peopleWithVCardRepresentation:vCardData];
				
				if (people != nil && [people count] != 0 && [people count] + [[peopleController content] count] <= [peopleController capacity]) {
					NSRange		range		= NSMakeRange(row, [people count]);
					NSIndexSet	*indexSet	= [NSIndexSet indexSetWithIndexesInRange:range];
					
					[peopleController insertObjects:people atArrangedObjectIndexes:indexSet];
					// set selected rows to those that were just copied
					[peopleController setSelectionIndexes:indexSet];
					return YES;
				}
			
			// -- load people from filename (NSFilenamesPboardType) --
			} else if ([type isEqualToString:NSFilenamesPboardType]) {
				NSArray *files				= [pboard propertyListForType:NSFilenamesPboardType];
				NSArray *acceptableFiles	= [files pathsMatchingExtensions:[self acceptableFileExtensions]];
		
				NSString		*file;
				NSMutableArray	*people		= [NSMutableArray arrayWithCapacity:[acceptableFiles count]];
				NSEnumerator	*enumerator	= [acceptableFiles objectEnumerator];
				while (file = [enumerator nextObject]) {
					id person = [[AHKPerson alloc] initWithVCardRepresentation:[NSData dataWithContentsOfFile:file] format:AHKKyoponVCardFormat];
					if (person != nil) {
						[people addObject:person];
						[person release];
					}
				}
				
				if ([people count] && [people count] + [[peopleController content] count] <= [peopleController capacity]) {
					NSRange		range		= NSMakeRange(row, [people count]);
					NSIndexSet	*indexSet	= [NSIndexSet indexSetWithIndexesInRange:range];
					[peopleController insertObjects:people atArrangedObjectIndexes:indexSet];
					// set selected rows to those that were just copied
					[peopleController setSelectionIndexes:indexSet];
					return YES;
				}
			}
		}
	}
	return result;
}

- (IBAction)copy:(id)sender
{
	NSIndexSet *rowIndexes = [peopleController selectionIndexes];
	if (rowIndexes && [rowIndexes count] > 0) {
		[self writePeopleAtIndexes:rowIndexes
					  toPasteboard:[NSPasteboard generalPasteboard]
							 types:[self distributablePasteboardTypes]];
	}
}

- (IBAction)paste:(id)sender
{
//	NSLog(@"%@", [[NSPasteboard generalPasteboard] types]);
//	if ([[NSPasteboard generalPasteboard] availableTypeFromArray:[NSArray arrayWithObject:@"ABPeopleDictPboardType"]]) {
//		NSLog(@"%@", [[NSPasteboard generalPasteboard] propertyListForType:@"ABPeopleDictPboardType"]);
//	}
	unsigned int row = [peopleController selectionIndex];
	if (row == NSNotFound) {
		row = 0;
	}
	if ([self insertPeopleFromPasteboard:[NSPasteboard generalPasteboard] atRow:row] == NO) {
		NSBeep();
	}
}

@end
